//
//   Look for calibrations in the file - Emiliano Mocchiutti
//
//   FCaloFINDCALIBS.cxx      version 1.01  (2006-03-08)
//
//   The only input needed is the path to the directory created by YODA for the data file you want to analyze.
//
//   Changelog:
//
//   1.00 - 1.01 (2006-03-08): Flight version, read unique YODA file.
//
//   0.00 - 1.00 (2006-03-08): Clone of CaloFINDCALIBS v2r06.
//
#include <fstream>
#include <sstream>
#include <TTree.h>
#include <TClassEdit.h>
#include <TObject.h>
#include <TList.h>
#include <TSystem.h>
#include <TSystemDirectory.h>
#include <TString.h>
#include <TFile.h>
#include <TClass.h>
#include <TCanvas.h>
#include <TH1.h>
#include <TH1F.h>
#include <TH2D.h>
#include <TLatex.h>
#include <TPad.h>
#include <TPaveLabel.h>
#include <TChain.h>
#include <fcalostructs.h>
extern TString whatnamewith(TString, Int_t);
extern int CaloFindCalibs(TString &, TString &, Int_t &, Calib &);
extern int OLDCaloFindCalibs(TString &, Calib &);
extern void stringcopy(TString&, const TString&, Int_t, Int_t);
//
using namespace std;

void FCaloFINDCALIBS(TString filename){
    struct Calib calib;
    //    
    for (Int_t s=0; s<4;s++){
	for (Int_t d = 0; d<51; d++){
	    calib.ttime[s][d] = 0 ;
	    calib.time[s][d] = 0 ;
	};
    };
    //
    // first of all find the calibrations in the file 
    //
    Int_t wused = 0;
    Int_t err = CaloFindCalibs(filename, filename, wused, calib);        
    if ( err ){
      printf("\n %s: no such file or directory \n\n",filename.Data());
      return;
    };
    //
    // print on the screen the results:   
    //
    const char *ffile = filename;		
    printf(" ------ %s ------- \n \n",ffile);	
    Int_t calibex = 0;
    TString pfile;
    for (Int_t s=0; s<4;s++){
	printf(" ** SECTION %i **\n",s);
	for (Int_t d = 0; d<51; d++){
	    if ( calib.ttime[s][d] != 0 ) {
		calibex++;
		if ( calib.fcode[s][d] != 10 ){
		    TString file2 = "";
		    stringcopy(file2,filename,0,0);
		    pfile = (TString)whatnamewith(file2,calib.fcode[s][d]);		    
		} else {
		    pfile = (TString)filename;
		};
		const char *ffile = pfile;		
		printf(" - from time %i to time %i use calibration at\n time %i, file: %s \n",calib.time[s][d],calib.time[s][d+1],calib.ttime[s][d],ffile);
	    };
	};
	printf("\n");	
    };
    printf(" ----------------------------------------------------------------------- \n \n");	
    if ( calibex < 4 ) {
	printf("No full calibration data in this file!\n");
    };
    //
    return;
}

void FCaloOLDFINDCALIBS(TString filename){
    struct Calib calib;
    //    
    for (Int_t s=0; s<4;s++){
	for (Int_t d = 0; d<50; d++){
	    calib.ttime[s][d] = 0 ;
	    if ( d < 49 ) calib.time[s][d] = 0 ;
	};
    };
    //
    // first of all find the calibrations in the file 
    //
    Int_t err = OLDCaloFindCalibs(filename, calib);    
    if ( err ){
      printf("\n %s: no such file or directory \n\n",filename.Data());
      return;
    };
    //
    // print on the screen the results:   
    //
    printf(" ---------------------------------------------------------- \n \n");	
    Int_t calibex = 0;
    for (Int_t s=0; s<4;s++){
	Int_t stop = 0;
	for (Int_t d = 0; d<48; d++){
	    if ( calib.ttime[s][d] != 0 ) calibex++;
	    if ( calib.time[s][0] != 0 ){
		if ( d == 0 )  printf(" Section %i from time 0 to time %i use calibration at time %i \n",s,calib.time[s][d],calib.ttime[s][d]);
		if ( calib.time[s][d+1] != 0 ) {
		    printf(" Section %i from time %i to time %i use calibration at time %i \n",s,calib.time[s][d],calib.time[s][d+1],calib.ttime[s][d+1]);
		} else {
		    if ( !stop ){
			printf(" Section %i from time %i use calibration at time %i \n",s,calib.time[s][d],calib.ttime[s][d+1]);		
			stop = 1;
		    };
		};
	    } else {
		if ( calib.ttime[s][d] != 0 ) printf(" Section %i from time 0 use calibration at time %i \n",s,calib.ttime[s][d]);
	    };
	};
	printf("\n");	
    };
    printf(" ---------------------------------------------------------- \n");	
    const char *ffile = filename;
    printf(" %s  \n",ffile);	
    if ( calibex < 4 ) {
	printf("No full calibration data in this file!\n");
    };
    //
    return;
}

